/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.immediate.model;

import java.util.Set;
import net.caffeinemc.mods.sodium.client.util.Int2;
import net.minecraft.class_2350;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public class ModelCuboid {
    public static final int NUM_CUBE_VERTICES = 8;
    public static final int NUM_CUBE_FACES = 6;
    public static final int NUM_FACE_VERTICES = 4;
    public static final int VERTEX_X0_Y0_Z0 = 0;
    public static final int VERTEX_X1_Y0_Z0 = 1;
    public static final int VERTEX_X1_Y1_Z0 = 2;
    public static final int VERTEX_X0_Y1_Z0 = 3;
    public static final int VERTEX_X0_Y0_Z1 = 4;
    public static final int VERTEX_X1_Y0_Z1 = 5;
    public static final int VERTEX_X1_Y1_Z1 = 6;
    public static final int VERTEX_X0_Y1_Z1 = 7;
    public static final int FACE_NEG_Y = 0;
    public static final int FACE_POS_Y = 1;
    public static final int FACE_NEG_X = 2;
    public static final int FACE_NEG_Z = 3;
    public static final int FACE_POS_X = 4;
    public static final int FACE_POS_Z = 5;
    public final float originX;
    public final float originY;
    public final float originZ;
    public final float sizeX;
    public final float sizeY;
    public final float sizeZ;
    private final int cullMask;
    public final int[] normals;
    public final int[] positions;
    public final long[] textures;

    public ModelCuboid(int u, int v, float x1, float y1, float z1, float sizeX, float sizeY, float sizeZ, float extraX, float extraY, float extraZ, boolean mirror, float textureWidth, float textureHeight, Set<class_2350> renderDirections) {
        float x2 = x1 + sizeX;
        float y2 = y1 + sizeY;
        float z2 = z1 + sizeZ;
        x1 -= extraX;
        y1 -= extraY;
        z1 -= extraZ;
        x2 += extraX;
        y2 += extraY;
        z2 += extraZ;
        if (mirror) {
            float tmp = x2;
            x2 = x1;
            x1 = tmp;
        }
        x1 /= 16.0f;
        y1 /= 16.0f;
        z1 /= 16.0f;
        x2 /= 16.0f;
        y2 /= 16.0f;
        z2 /= 16.0f;
        this.originX = x1;
        this.originY = y1;
        this.originZ = z1;
        this.sizeX = x2 - x1;
        this.sizeY = y2 - y1;
        this.sizeZ = z2 - z1;
        float scaleU = 1.0f / textureWidth;
        float scaleV = 1.0f / textureHeight;
        float u0 = scaleU * (float)u;
        float u1 = scaleU * ((float)u + sizeZ);
        float u2 = scaleU * ((float)u + sizeZ + sizeX);
        float u3 = scaleU * ((float)u + sizeZ + sizeX + sizeX);
        float u4 = scaleU * ((float)u + sizeZ + sizeX + sizeZ);
        float u5 = scaleU * ((float)u + sizeZ + sizeX + sizeZ + sizeX);
        float v0 = scaleV * (float)v;
        float v1 = scaleV * ((float)v + sizeZ);
        float v2 = scaleV * ((float)v + sizeZ + sizeY);
        this.cullMask = ModelCuboid.createCullMask(renderDirections);
        int[] positions = new int[24];
        long[] textures = new long[24];
        int[] normals = new int[]{0, 1, 2, 3, 4, 5};
        ModelCuboid.writeVertexList(positions, 0, 5, 4, 0, 1);
        ModelCuboid.writeTexCoords(textures, 0, u1, v0, u2, v1);
        ModelCuboid.writeVertexList(positions, 1, 2, 3, 7, 6);
        ModelCuboid.writeTexCoords(textures, 1, u2, v1, u3, v0);
        ModelCuboid.writeVertexList(positions, 3, 1, 0, 3, 2);
        ModelCuboid.writeTexCoords(textures, 3, u1, v1, u2, v2);
        ModelCuboid.writeVertexList(positions, 5, 4, 5, 6, 7);
        ModelCuboid.writeTexCoords(textures, 5, u4, v1, u5, v2);
        ModelCuboid.writeVertexList(positions, 2, 5, 1, 2, 6);
        ModelCuboid.writeTexCoords(textures, 2, u2, v1, u4, v2);
        ModelCuboid.writeVertexList(positions, 4, 0, 4, 7, 3);
        ModelCuboid.writeTexCoords(textures, 4, u0, v1, u1, v2);
        if (mirror) {
            ModelCuboid.reverseVertices(positions, textures);
            normals[4] = 2;
            normals[2] = 4;
        }
        this.normals = normals;
        this.positions = positions;
        this.textures = textures;
    }

    private static int createCullMask(Set<class_2350> directions) {
        int mask = 0;
        for (class_2350 direction : directions) {
            mask |= 1 << ModelCuboid.getFaceIndex(direction);
        }
        return mask;
    }

    private static void reverseVertices(int[] vertices, long[] texCoords) {
        for (int faceIndex = 0; faceIndex < 6; ++faceIndex) {
            int vertexOffset = faceIndex * 4;
            ArrayUtils.swap((int[])vertices, (int)(vertexOffset + 0), (int)(vertexOffset + 3));
            ArrayUtils.swap((int[])vertices, (int)(vertexOffset + 1), (int)(vertexOffset + 2));
            ArrayUtils.swap((long[])texCoords, (int)(vertexOffset + 0), (int)(vertexOffset + 3));
            ArrayUtils.swap((long[])texCoords, (int)(vertexOffset + 1), (int)(vertexOffset + 2));
        }
    }

    private static void writeVertexList(int[] positions, int faceIndex, int i0, int i1, int i2, int i3) {
        positions[faceIndex * 4 + 0] = i0;
        positions[faceIndex * 4 + 1] = i1;
        positions[faceIndex * 4 + 2] = i2;
        positions[faceIndex * 4 + 3] = i3;
    }

    private static void writeTexCoords(long[] textures, int faceIndex, float u1, float v1, float u2, float v2) {
        textures[faceIndex * 4 + 0] = Int2.pack(Float.floatToRawIntBits(u2), Float.floatToRawIntBits(v1));
        textures[faceIndex * 4 + 1] = Int2.pack(Float.floatToRawIntBits(u1), Float.floatToRawIntBits(v1));
        textures[faceIndex * 4 + 2] = Int2.pack(Float.floatToRawIntBits(u1), Float.floatToRawIntBits(v2));
        textures[faceIndex * 4 + 3] = Int2.pack(Float.floatToRawIntBits(u2), Float.floatToRawIntBits(v2));
    }

    public boolean shouldDrawFace(int faceIndex) {
        return (this.cullMask & 1 << faceIndex) != 0;
    }

    private static int getFaceIndex(@NotNull class_2350 dir) {
        return switch (dir) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033 -> 0;
            case class_2350.field_11036 -> 1;
            case class_2350.field_11043 -> 3;
            case class_2350.field_11035 -> 5;
            case class_2350.field_11039 -> 2;
            case class_2350.field_11034 -> 4;
        };
    }
}

