/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.util.sorting;

import it.unimi.dsi.fastutil.ints.IntArrays;

public class RadixSort {
    private static final int RADIX_SORT_THRESHOLD = 80;
    private static final int DIGIT_BITS = 8;
    private static final int RADIX_KEY_BITS = 32;
    private static final int BUCKET_COUNT = 256;
    private static final int DIGIT_COUNT = 4;
    private static final int DIGIT_MASK = 255;

    private static void getHistogram(int[][] histogram, int[] keys) {
        for (int key : keys) {
            for (int digit = 0; digit < 4; ++digit) {
                int[] nArray = histogram[digit];
                int n = RadixSort.extractDigit(key, digit);
                nArray[n] = nArray[n] + 1;
            }
        }
    }

    private static void prefixSums(int[][] offsets) {
        for (int digit = 0; digit < 4; ++digit) {
            int[] buckets = offsets[digit];
            int sum = 0;
            for (int bucket_idx = 0; bucket_idx < 256; ++bucket_idx) {
                int offset = sum;
                sum += buckets[bucket_idx];
                buckets[bucket_idx] = offset;
            }
        }
    }

    public static void sortIndirect(int[] perm, int[] keys, boolean stable) {
        if (perm.length <= 80) {
            RadixSort.smallSort(perm, keys, stable);
            return;
        }
        try {
            int[][] offsets = new int[4][256];
            int[] next = new int[perm.length];
            RadixSort.sortIndirect(perm, keys, offsets, next);
        }
        catch (OutOfMemoryError oom) {
            Object offsets = null;
            Object next = null;
            RadixSort.fallbackSort(perm, keys, stable);
        }
    }

    private static void sortIndirect(int[] perm, int[] keys, int[][] offsets, int[] next) {
        int length = perm.length;
        RadixSort.getHistogram(offsets, keys);
        RadixSort.prefixSums(offsets);
        int[] cur = perm;
        for (int digit = 0; digit < 4; ++digit) {
            int[] buckets = offsets[digit];
            for (int pos = 0; pos < length; ++pos) {
                int index = cur[pos];
                int bucket_idx = RadixSort.extractDigit(keys[index], digit);
                next[buckets[bucket_idx]] = index;
                int n = bucket_idx;
                buckets[n] = buckets[n] + 1;
            }
            int[] temp = next;
            next = cur;
            cur = temp;
        }
    }

    private static void smallSort(int[] perm, int[] keys, boolean stable) {
        if (perm.length <= 1) {
            return;
        }
        RadixSort.fallbackSort(perm, keys, stable);
    }

    private static void fallbackSort(int[] perm, int[] keys, boolean stable) {
        IntArrays.quickSortIndirect((int[])perm, (int[])keys);
        if (stable) {
            IntArrays.stabilize((int[])perm, (int[])keys);
        }
    }

    private static int extractDigit(int key, int digit) {
        return key >>> digit * 8 & 0xFF;
    }
}

