/*
 * Decompiled with CFR 0.152.
 */
package com.plasmoverse.opus;

import com.plasmoverse.opus.OpusException;
import com.plasmoverse.opus.OpusLibrary;
import java.io.IOException;

public final class OpusDecoder {
    private final long pointer;

    public static OpusDecoder create(int sampleRate, boolean stereo, int frameSize) throws IOException, OpusException {
        OpusLibrary.load();
        long pointer = OpusDecoder.createNative(sampleRate, stereo, frameSize);
        return new OpusDecoder(pointer);
    }

    private static native long createNative(int var0, boolean var1, int var2);

    private OpusDecoder(long pointer) {
        this.pointer = pointer;
    }

    public short[] decode(byte[] encoded) throws OpusException {
        if (!this.isOpen()) {
            throw new OpusException("Decoder is closed");
        }
        return this.decodeNative(encoded);
    }

    public void reset() {
        if (!this.isOpen()) {
            return;
        }
        this.resetNative();
    }

    public void close() {
        if (!this.isOpen()) {
            return;
        }
        this.closeNative();
    }

    public boolean isOpen() {
        return this.pointer > 0L;
    }

    private native short[] decodeNative(byte[] var1);

    private native void resetNative();

    private native void closeNative();
}

