/*
 * Decompiled with CFR 0.152.
 */
package su.plo.config.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import su.plo.config.Config;
import su.plo.config.provider.toml.TomlConfiguration;

public abstract class ConfigurationProvider {
    private static final Map<Class<? extends ConfigurationProvider>, ConfigurationProvider> providers = new HashMap<Class<? extends ConfigurationProvider>, ConfigurationProvider>();

    public static <T> T getProvider(Class<? extends ConfigurationProvider> provider) {
        return (T)providers.get(provider);
    }

    public <T> T load(Class<?> clazz, @Nonnull File file, boolean saveDefault) throws IOException {
        if (!clazz.isAnnotationPresent(Config.class)) {
            throw new IllegalArgumentException("Class not annotated with @Config");
        }
        T config = null;
        if (file.exists()) {
            config = this.load(clazz, file);
        }
        if (config == null) {
            try {
                config = (T)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException("No default constructor in class");
            }
            if (saveDefault) {
                this.save(clazz, config, file);
            }
        }
        return config;
    }

    public <T> T load(Class<?> clazz, @Nonnull File file, @Nonnull Object defaultConfiguration) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            Object object = this.load(clazz, (InputStream)is, defaultConfiguration);
            return (T)object;
        }
    }

    public <T> T load(Class<?> clazz, @Nonnull File file, @Nonnull InputStream defaultConfiguration) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            Object object = this.load(clazz, (InputStream)is, defaultConfiguration);
            return (T)object;
        }
    }

    public <T> T load(Class<?> clazz, @Nonnull InputStream is) throws IOException {
        try {
            return (T)this.load(clazz, is, clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to initialize configuration class", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T load(Class<?> clazz, @Nonnull File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            Object object = this.load(clazz, (InputStream)is, clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            return (T)object;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to initialize configuration class", e);
        }
    }

    protected abstract Object load(Class<?> var1, @Nonnull InputStream var2, @Nonnull Object var3) throws IOException;

    protected abstract Object load(Class<?> var1, @Nonnull InputStream var2, @Nonnull InputStream var3) throws IOException;

    public abstract Object serialize(Object var1);

    public abstract void deserialize(Object var1, Object var2);

    public abstract void save(Class<?> var1, @Nonnull Object var2, @Nonnull File var3) throws IOException;

    static {
        try {
            providers.put(TomlConfiguration.class, new TomlConfiguration());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

