/*
 * Decompiled with CFR 0.152.
 */
package su.plo.slib.chat;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.slib.api.chat.component.McTranslatableText;
import su.plo.slib.api.chat.converter.ServerTextConverter;
import su.plo.slib.api.chat.style.McTextClickEvent;
import su.plo.slib.api.chat.style.McTextHoverEvent;
import su.plo.slib.api.chat.style.McTextStyle;
import su.plo.slib.libs.adventure.adventure.text.Component;
import su.plo.slib.libs.adventure.adventure.text.ComponentLike;
import su.plo.slib.libs.adventure.adventure.text.TextComponent;
import su.plo.slib.libs.adventure.adventure.text.TranslatableComponent;
import su.plo.slib.libs.adventure.adventure.text.event.ClickEvent;
import su.plo.slib.libs.adventure.adventure.text.event.HoverEvent;
import su.plo.slib.libs.adventure.adventure.text.format.NamedTextColor;
import su.plo.slib.libs.adventure.adventure.text.format.Style;
import su.plo.slib.libs.adventure.adventure.text.format.StyleSetter;
import su.plo.slib.libs.adventure.adventure.text.format.TextDecoration;
import su.plo.slib.libs.adventure.adventure.text.serializer.gson.GsonComponentSerializer;
import su.plo.slib.libs.adventure.adventure.text.serializer.json.JSONOptions;
import su.plo.slib.libs.adventure.adventure.translation.GlobalTranslator;
import su.plo.slib.libs.adventure.adventure.translation.Translator;
import su.plo.slib.libs.adventure.option.OptionState;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001c\u0010\t\u001a\u00070\u0005\u00a2\u0006\u0002\b\r2\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\t\u0010\u000eJ\u001c\u0010\u0010\u001a\u00070\u0002\u00a2\u0006\u0002\b\r2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J!\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00022\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ!\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00022\b\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010 \u001a\u00020\u001f2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b \u0010!J\u001f\u0010&\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010%\u001a\u00020$H\u0002\u00a2\u0006\u0004\b&\u0010'R\u0019\u0010)\u001a\u00070(\u00a2\u0006\u0002\b\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lsu/plo/slib/chat/AdventureComponentTextConverter;", "Lsu/plo/slib/api/chat/converter/ServerTextConverter;", "Lsu/plo/slib/libs/adventure/adventure/text/Component;", "<init>", "()V", "", "language", "Lsu/plo/slib/api/chat/component/McTextComponent;", "text", "convertToJson", "(Ljava/lang/String;Lsu/plo/slib/api/chat/component/McTextComponent;)Ljava/lang/String;", "convert", "(Ljava/lang/String;Lsu/plo/slib/api/chat/component/McTextComponent;)Lsu/plo/slib/libs/adventure/adventure/text/Component;", "Lorg/jetbrains/annotations/NotNull;", "(Lsu/plo/slib/libs/adventure/adventure/text/Component;)Ljava/lang/String;", "json", "convertFromJson", "(Ljava/lang/String;)Lsu/plo/slib/libs/adventure/adventure/text/Component;", "(Lsu/plo/slib/api/chat/component/McTextComponent;)Lsu/plo/slib/libs/adventure/adventure/text/Component;", "Lsu/plo/slib/api/chat/component/McTranslatableText;", "convertTranslatable", "(Lsu/plo/slib/api/chat/component/McTranslatableText;)Lsu/plo/slib/libs/adventure/adventure/text/Component;", "component", "Lsu/plo/slib/api/chat/style/McTextClickEvent;", "clickEvent", "applyClickEvent", "(Lsu/plo/slib/libs/adventure/adventure/text/Component;Lsu/plo/slib/api/chat/style/McTextClickEvent;)Lsu/plo/slib/libs/adventure/adventure/text/Component;", "Lsu/plo/slib/api/chat/style/McTextHoverEvent;", "hoverEvent", "applyHoverEvent", "(Lsu/plo/slib/libs/adventure/adventure/text/Component;Lsu/plo/slib/api/chat/style/McTextHoverEvent;)Lsu/plo/slib/libs/adventure/adventure/text/Component;", "Lsu/plo/slib/libs/adventure/adventure/text/format/Style;", "getStyles", "(Lsu/plo/slib/api/chat/component/McTextComponent;)Lsu/plo/slib/libs/adventure/adventure/text/format/Style;", "Lsu/plo/slib/libs/adventure/adventure/text/format/Style$Builder;", "builder", "Lsu/plo/slib/api/chat/style/McTextStyle;", "style", "convertStyle", "(Lsu/plo/slib/libs/adventure/adventure/text/format/Style$Builder;Lsu/plo/slib/api/chat/style/McTextStyle;)Lsu/plo/slib/libs/adventure/adventure/text/format/Style$Builder;", "Lsu/plo/slib/libs/adventure/adventure/text/serializer/gson/GsonComponentSerializer;", "gsonComponentSerializer", "Lsu/plo/slib/libs/adventure/adventure/text/serializer/gson/GsonComponentSerializer;", "common"})
@SourceDebugExtension(value={"SMAP\nAdventureComponentTextConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdventureComponentTextConverter.kt\nsu/plo/slib/chat/AdventureComponentTextConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1863#2,2:124\n1863#2,2:126\n*S KotlinDebug\n*F\n+ 1 AdventureComponentTextConverter.kt\nsu/plo/slib/chat/AdventureComponentTextConverter\n*L\n62#1:124,2\n110#1:126,2\n*E\n"})
public final class AdventureComponentTextConverter
implements ServerTextConverter<Component> {
    @NotNull
    private final GsonComponentSerializer gsonComponentSerializer;

    public AdventureComponentTextConverter() {
        GsonComponentSerializer gsonComponentSerializer = ((GsonComponentSerializer.Builder)GsonComponentSerializer.gson().toBuilder()).editOptions(AdventureComponentTextConverter::gsonComponentSerializer$lambda$0).build();
        Intrinsics.checkNotNullExpressionValue(gsonComponentSerializer, "build(...)");
        this.gsonComponentSerializer = gsonComponentSerializer;
    }

    @Override
    @NotNull
    public String convertToJson(@NotNull String language, @NotNull McTextComponent text) {
        Intrinsics.checkNotNullParameter(language, "language");
        Intrinsics.checkNotNullParameter(text, "text");
        Component translatedComponent = this.convert(language, text);
        return this.convertToJson(translatedComponent);
    }

    @Override
    @NotNull
    public Component convert(@NotNull String language, @NotNull McTextComponent text) {
        Intrinsics.checkNotNullParameter(language, "language");
        Intrinsics.checkNotNullParameter(text, "text");
        Component component = this.convert(text);
        Locale locale = Translator.parseLocale(language);
        Intrinsics.checkNotNull(locale);
        Component component2 = GlobalTranslator.render(component, locale);
        Intrinsics.checkNotNullExpressionValue(component2, "render(...)");
        return component2;
    }

    @Override
    @NotNull
    public String convertToJson(@NotNull Component text) {
        Intrinsics.checkNotNullParameter(text, "text");
        Object r = this.gsonComponentSerializer.serialize(text);
        Intrinsics.checkNotNullExpressionValue(r, "serialize(...)");
        return (String)r;
    }

    @Override
    @NotNull
    public Component convertFromJson(@NotNull String json) {
        Intrinsics.checkNotNullParameter(json, "json");
        Object o = this.gsonComponentSerializer.deserialize(json);
        Intrinsics.checkNotNullExpressionValue(o, "deserialize(...)");
        return o;
    }

    @Override
    @NotNull
    public Component convert(@NotNull McTextComponent text) {
        Component component;
        Intrinsics.checkNotNullParameter(text, "text");
        Component component2 = null;
        if (text instanceof McTranslatableText) {
            component = this.convertTranslatable((McTranslatableText)text);
        } else {
            TextComponent textComponent = Component.text(text.toString());
            Intrinsics.checkNotNullExpressionValue(textComponent, "text(...)");
            component = textComponent;
        }
        component2 = component;
        component2 = component2.style(this.getStyles(text));
        component2 = this.applyClickEvent(component2, text.getClickEvent());
        component2 = this.applyHoverEvent(component2, text.getHoverEvent());
        Iterable $this$forEach$iv = text.getSiblings();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            McTextComponent it = (McTextComponent)element$iv;
            boolean bl = false;
            component2 = component2.append(this.convert(it));
        }
        return component2;
    }

    private final Component convertTranslatable(McTranslatableText text) {
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue(arrayList, "newArrayList(...)");
        List args2 = arrayList;
        int n = text.getArgs().length;
        for (int i = 0; i < n; ++i) {
            boolean bl;
            Object arg = text.getArgs()[i];
            if (arg instanceof McTextComponent) {
                bl = args2.add(this.convert((McTextComponent)arg));
                continue;
            }
            TextComponent textComponent = Component.text(arg.toString());
            Intrinsics.checkNotNullExpressionValue(textComponent, "text(...)");
            bl = args2.add(textComponent);
        }
        TranslatableComponent translatableComponent = Component.translatable(text.getKey(), (List<? extends ComponentLike>)args2);
        Intrinsics.checkNotNullExpressionValue(translatableComponent, "translatable(...)");
        return translatableComponent;
    }

    private final Component applyClickEvent(Component component, McTextClickEvent clickEvent) {
        Component component2;
        if (clickEvent == null) {
            component2 = component;
        } else {
            Component component3 = component.clickEvent(ClickEvent.clickEvent(ClickEvent.Action.valueOf(clickEvent.getAction().name()), clickEvent.getValue()));
            component2 = component3;
            Intrinsics.checkNotNullExpressionValue(component3, "clickEvent(...)");
        }
        return component2;
    }

    private final Component applyHoverEvent(Component component, McTextHoverEvent hoverEvent) {
        StyleSetter<Component> styleSetter;
        if (hoverEvent == null) {
            return component;
        }
        if (hoverEvent.getAction() == McTextHoverEvent.Action.SHOW_TEXT) {
            Object object = hoverEvent.getValue();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type su.plo.slib.api.chat.component.McTextComponent");
            StyleSetter styleSetter2 = component.hoverEvent(HoverEvent.showText(this.convert((McTextComponent)object)));
            Intrinsics.checkNotNull(styleSetter2);
            styleSetter = styleSetter2;
        } else {
            styleSetter = component;
        }
        return styleSetter;
    }

    private final Style getStyles(McTextComponent text) {
        Style.Builder builder = Style.style();
        Intrinsics.checkNotNullExpressionValue(builder, "style(...)");
        Style.Builder builder2 = builder;
        Iterable $this$forEach$iv = text.getStyles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            McTextStyle it = (McTextStyle)((Object)element$iv);
            boolean bl = false;
            this.convertStyle(builder2, it);
        }
        Style style = builder2.build();
        Intrinsics.checkNotNullExpressionValue(style, "build(...)");
        return style;
    }

    private final Style.Builder convertStyle(Style.Builder builder, McTextStyle style) {
        if (style.getType() == McTextStyle.Type.COLOR) {
            String string = style.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            builder.color(NamedTextColor.NAMES.value(string));
        } else if (style.getType() == McTextStyle.Type.DECORATION) {
            String string = style.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            TextDecoration textDecoration = TextDecoration.NAMES.value(string);
            Intrinsics.checkNotNull(textDecoration);
            builder.decoration(textDecoration, true);
        }
        return builder;
    }

    private static final void gsonComponentSerializer$lambda$0(OptionState.Builder it) {
        it.values(JSONOptions.compatibility());
    }
}

