/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.filter;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.config.entry.ConfigEntry;
import su.plo.config.entry.IntConfigEntry;
import su.plo.voice.api.client.audio.filter.AudioFilter;
import su.plo.voice.api.client.audio.filter.AudioFilterContext;
import su.plo.voice.api.util.AudioUtil;

public class LimiterFilter
implements AudioFilter {
    private static final float SLOPE = 1.0f;
    private static final float OUTPUT_GAIN = AudioUtil.dbToMul(0.0f);
    private static final float DEFAULT_THRESHOLD = -6.0f;
    private final int sampleRate;
    private final Float threshold;
    @Nullable
    private final ConfigEntry<Boolean> activeEntry;
    @Nullable
    private final IntConfigEntry thresholdEntry;
    private float[] envelopeBuf = new float[0];
    private float envelope;

    public LimiterFilter(int sampleRate, Float threshold) {
        this(sampleRate, threshold, null, null);
    }

    public LimiterFilter(int sampleRate, @Nullable ConfigEntry<Boolean> activeEntry, @Nullable IntConfigEntry thresholdEntry) {
        this(sampleRate, null, activeEntry, thresholdEntry);
    }

    private LimiterFilter(int sampleRate, Float threshold, @Nullable ConfigEntry<Boolean> activeEntry, @Nullable IntConfigEntry thresholdEntry) {
        this.sampleRate = sampleRate;
        this.threshold = threshold;
        this.activeEntry = activeEntry;
        this.thresholdEntry = thresholdEntry;
    }

    @Override
    @NotNull
    public String getName() {
        return "limiter";
    }

    @Override
    public short[] process(@NotNull AudioFilterContext context, short[] samples) {
        float[] floatSamples = AudioUtil.shortsToFloatsRange(samples);
        this.analyzeEnvelope(floatSamples);
        this.limit(floatSamples);
        return AudioUtil.floatsRangeToShort(floatSamples);
    }

    @Override
    public boolean isEnabled() {
        return this.activeEntry.value();
    }

    @Override
    public int getSupportedChannels() {
        return 1;
    }

    public synchronized void limit(float[] samples) {
        float limiterThreshold = this.thresholdEntry != null ? (float)((Integer)this.thresholdEntry.value()).intValue() : (this.threshold != null ? this.threshold.floatValue() : -6.0f);
        int i = 0;
        while (i < samples.length) {
            float envDB = AudioUtil.mulToDB(this.envelopeBuf[i]);
            float limiterGain = 1.0f * (limiterThreshold - envDB);
            limiterGain = AudioUtil.dbToMul(Math.min(0.0f, limiterGain));
            int n = i++;
            samples[n] = samples[n] * (limiterGain * OUTPUT_GAIN);
        }
    }

    private synchronized void analyzeEnvelope(float[] samples) {
        this.envelopeBuf = new float[samples.length];
        float attackGain = AudioUtil.gainCoefficient(this.sampleRate, 1.0E-6f);
        float releaseGain = AudioUtil.gainCoefficient(this.sampleRate, 0.06f);
        float env = this.envelope;
        for (int i = 0; i < samples.length; ++i) {
            float envIn = Math.abs(samples[i]);
            env = env < envIn ? envIn + attackGain * (env - envIn) : envIn + releaseGain * (env - envIn);
            this.envelopeBuf[i] = Math.max(this.envelopeBuf[i], env);
        }
        this.envelope = this.envelopeBuf[samples.length - 1];
    }
}

