/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets.tcp.serverbound;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.UUID;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.PacketUtil;
import su.plo.voice.proto.packets.tcp.serverbound.ServerPacketTcpHandler;

public class SourceInfoRequestPacket
implements Packet<ServerPacketTcpHandler> {
    private UUID sourceId;

    @Override
    public void read(ByteArrayDataInput in) throws IOException {
        this.sourceId = PacketUtil.readUUID(in);
    }

    @Override
    public void write(ByteArrayDataOutput out) throws IOException {
        PacketUtil.writeUUID(out, (UUID)Preconditions.checkNotNull((Object)this.sourceId));
    }

    @Override
    public void handle(ServerPacketTcpHandler handler) {
        handler.handle(this);
    }

    public SourceInfoRequestPacket(UUID sourceId) {
        this.sourceId = sourceId;
    }

    public SourceInfoRequestPacket() {
    }

    public String toString() {
        return "SourceInfoRequestPacket(sourceId=" + this.getSourceId() + ")";
    }

    public UUID getSourceId() {
        return this.sourceId;
    }
}

