/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.audio.source;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.server.entity.McServerEntity;
import su.plo.slib.api.server.position.ServerPos3d;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.server.PlasmoVoiceServer;
import su.plo.voice.api.server.audio.line.ServerSourceLine;
import su.plo.voice.api.server.audio.source.ServerEntitySource;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.data.audio.source.EntitySourceInfo;
import su.plo.voice.server.audio.source.VoiceServerProximitySource;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B9\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lsu/plo/voice/server/audio/source/VoiceServerEntitySource;", "Lsu/plo/voice/server/audio/source/VoiceServerProximitySource;", "Lsu/plo/voice/proto/data/audio/source/EntitySourceInfo;", "Lsu/plo/voice/api/server/audio/source/ServerEntitySource;", "voiceServer", "Lsu/plo/voice/api/server/PlasmoVoiceServer;", "addon", "Lsu/plo/voice/api/addon/AddonContainer;", "line", "Lsu/plo/voice/api/server/audio/line/ServerSourceLine;", "decoderInfo", "Lsu/plo/voice/proto/data/audio/codec/CodecInfo;", "stereo", "", "entity", "Lsu/plo/slib/api/server/entity/McServerEntity;", "<init>", "(Lsu/plo/voice/api/server/PlasmoVoiceServer;Lsu/plo/voice/api/addon/AddonContainer;Lsu/plo/voice/api/server/audio/line/ServerSourceLine;Lsu/plo/voice/proto/data/audio/codec/CodecInfo;ZLsu/plo/slib/api/server/entity/McServerEntity;)V", "getEntity", "()Lsu/plo/slib/api/server/entity/McServerEntity;", "position", "Lsu/plo/slib/api/server/position/ServerPos3d;", "getPosition", "()Lsu/plo/slib/api/server/position/ServerPos3d;", "sourceInfo", "getSourceInfo", "()Lsu/plo/voice/proto/data/audio/source/EntitySourceInfo;", "resolveSourceInfo", "Ljava/util/concurrent/CompletableFuture;", "common"})
public final class VoiceServerEntitySource
extends VoiceServerProximitySource<EntitySourceInfo>
implements ServerEntitySource {
    @NotNull
    private final PlasmoVoiceServer voiceServer;
    @NotNull
    private final McServerEntity entity;

    public VoiceServerEntitySource(@NotNull PlasmoVoiceServer voiceServer, @NotNull AddonContainer addon, @NotNull ServerSourceLine line, @Nullable CodecInfo decoderInfo, boolean stereo, @NotNull McServerEntity entity) {
        Intrinsics.checkNotNullParameter(voiceServer, "voiceServer");
        Intrinsics.checkNotNullParameter(addon, "addon");
        Intrinsics.checkNotNullParameter(line, "line");
        Intrinsics.checkNotNullParameter(entity, "entity");
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue(uUID, "randomUUID(...)");
        super(voiceServer, addon, uUID, line, decoderInfo, stereo);
        this.voiceServer = voiceServer;
        this.entity = entity;
    }

    @Override
    @NotNull
    public McServerEntity getEntity() {
        return this.entity;
    }

    @Override
    @NotNull
    public ServerPos3d getPosition() {
        return this.getEntity().getServerPosition();
    }

    @Override
    @NotNull
    public EntitySourceInfo getSourceInfo() {
        return new EntitySourceInfo(this.addon.getId(), this.id, this.line.getId(), this.name, (byte)this.state.get(), this.decoderInfo, this.stereo, this.iconVisible, this.getAngle(), this.getEntity().getId());
    }

    @Override
    @NotNull
    public CompletableFuture<EntitySourceInfo> resolveSourceInfo() {
        return this.voiceServer.getMinecraftServer().getScheduler().runTaskFor(this.getEntity(), () -> VoiceServerEntitySource.resolveSourceInfo$lambda$0(this));
    }

    private static final EntitySourceInfo resolveSourceInfo$lambda$0(VoiceServerEntitySource this$0) {
        return this$0.getSourceInfo();
    }
}

