/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.mute;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.voice.api.server.event.mute.PlayerVoiceMutedEvent;
import su.plo.voice.api.server.event.mute.PlayerVoiceUnmutedEvent;
import su.plo.voice.api.server.mute.MuteDurationUnit;
import su.plo.voice.api.server.mute.MuteManager;
import su.plo.voice.api.server.mute.ServerMuteInfo;
import su.plo.voice.api.server.mute.storage.MuteStorage;
import su.plo.voice.api.server.player.VoiceServerPlayer;
import su.plo.voice.server.BaseVoiceServer;
import su.plo.voice.server.player.VoiceServerPlayerManagerImpl;

public final class VoiceMuteManager
implements MuteManager {
    private final BaseVoiceServer voiceServer;
    private final VoiceServerPlayerManagerImpl playerManager;
    private MuteStorage muteStorage;

    public static boolean isMuteValid(@NotNull ServerMuteInfo muteInfo) {
        return muteInfo.getMutedToTime() == 0L || muteInfo.getMutedToTime() > System.currentTimeMillis();
    }

    public VoiceMuteManager(@NotNull BaseVoiceServer voiceServer, @NotNull MuteStorage muteStorage, @NotNull ScheduledExecutorService executor) {
        this.voiceServer = voiceServer;
        this.muteStorage = muteStorage;
        this.playerManager = voiceServer.getPlayerManager();
        executor.scheduleAtFixedRate(this::tick, 0L, 5L, TimeUnit.SECONDS);
    }

    @Override
    public Optional<ServerMuteInfo> mute(@NotNull UUID playerId, @Nullable UUID mutedById, long duration, @Nullable MuteDurationUnit durationUnit, @Nullable String reason, boolean silent) {
        McTextComponent durationMessage;
        VoiceServerPlayer player = (VoiceServerPlayer)this.playerManager.getPlayerById(playerId).orElseThrow(() -> new IllegalArgumentException("Player not found"));
        if (duration > 0L && durationUnit == null) {
            throw new IllegalArgumentException("durationUnit cannot be null if duration > 0");
        }
        if (durationUnit == MuteDurationUnit.TIMESTAMP && duration - System.currentTimeMillis() <= 0L) {
            throw new IllegalArgumentException("TIMESTAMP duration should be in the future");
        }
        McTextComponent mcTextComponent = durationMessage = durationUnit == null ? McTextComponent.empty() : durationUnit.translate(duration);
        if (duration > 0L) {
            duration = durationUnit.multiply(duration);
            if (durationUnit != MuteDurationUnit.TIMESTAMP) {
                duration += System.currentTimeMillis();
            }
        }
        ServerMuteInfo muteInfo = new ServerMuteInfo(playerId, mutedById, System.currentTimeMillis(), duration, reason);
        this.muteStorage.putPlayerMute(player.getInstance().getUuid(), muteInfo);
        this.voiceServer.getTcpPacketManager().broadcastPlayerInfoUpdate(player);
        if (!silent) {
            if (duration > 0L) {
                player.getInstance().sendMessage(McTextComponent.translatable("pv.mutes.temporarily_muted", durationMessage, this.formatMuteReason(reason)));
            } else {
                player.getInstance().sendMessage(McTextComponent.translatable("pv.mutes.permanently_muted", this.formatMuteReason(reason)));
            }
        }
        this.voiceServer.getEventBus().fire(new PlayerVoiceMutedEvent(this, muteInfo));
        return Optional.of(muteInfo);
    }

    @Override
    public Optional<ServerMuteInfo> unmute(@NotNull UUID playerId, boolean silent) {
        return this.muteStorage.removeMuteByPlayerId(playerId).map(muteInfo -> {
            this.playerManager.getPlayerById(playerId).ifPresent(player -> {
                this.voiceServer.getTcpPacketManager().broadcastPlayerInfoUpdate((VoiceServerPlayer)player);
                if (!silent) {
                    player.getInstance().sendMessage(McTextComponent.translatable("pv.mutes.unmuted", new Object[0]));
                }
            });
            this.voiceServer.getEventBus().fire(new PlayerVoiceUnmutedEvent(this, (ServerMuteInfo)muteInfo));
            return muteInfo;
        });
    }

    @Override
    public Optional<ServerMuteInfo> getMute(@NotNull UUID playerId) {
        return this.muteStorage.getMuteByPlayerId(playerId);
    }

    @Override
    public void setMuteStorage(@NotNull MuteStorage muteStorage) {
        this.muteStorage = muteStorage;
    }

    public McTextComponent formatMuteReason(@Nullable String reason) {
        return reason == null ? McTextComponent.translatable("pv.mutes.empty_reason", new Object[0]) : McTextComponent.literal(reason);
    }

    private void tick() {
        this.muteStorage.getMutedPlayers().forEach(muteInfo -> {
            if (!VoiceMuteManager.isMuteValid(muteInfo)) {
                this.unmute(muteInfo.getPlayerUUID(), false);
            }
        });
    }

    @Override
    public MuteStorage getMuteStorage() {
        return this.muteStorage;
    }
}

