/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.main.network;

import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.api.events.client.ClientNetworkEvents;
import io.github.kosmx.emotes.api.proxy.EmotesProxyManager;
import io.github.kosmx.emotes.api.proxy.INetworkInstance;
import io.github.kosmx.emotes.common.CommonData;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.network.ClientEmotePlay;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;

public final class ClientPacketManager
extends EmotesProxyManager {
    private static final INetworkInstance defaultNetwork = PlatformTools.getClientNetworkController();

    public static void init() {
        ClientPacketManager.setManager(new ClientPacketManager());
    }

    private ClientPacketManager() {
    }

    private static boolean useAlwaysAlt() {
        return false;
    }

    public static void send(EmotePacket.Builder packetBuilder, UUID target) {
        ((ClientNetworkEvents.PacketSendEvent)ClientNetworkEvents.PACKET_SEND.invoker()).onPacketSend(packetBuilder);
        if (!defaultNetwork.isActive() || ClientPacketManager.useAlwaysAlt()) {
            for (INetworkInstance network : networkInstances) {
                if (!network.isActive() || target != null && network.isServerTrackingPlayState()) continue;
                try {
                    EmotePacket.Builder builder = packetBuilder.copy();
                    if (!network.sendPlayerID()) {
                        builder.removePlayerID();
                    }
                    builder.setSizeLimit(network.maxDataSize(), false);
                    builder.setVersion(network.getRemoteVersions());
                    network.sendMessage(builder, target);
                }
                catch (IOException exception) {
                    CommonData.LOGGER.error("Error while sending packet!", (Throwable)exception);
                }
            }
        }
        if (defaultNetwork.isActive() && (target == null || !defaultNetwork.isServerTrackingPlayState())) {
            if (!defaultNetwork.sendPlayerID()) {
                packetBuilder.removePlayerID();
            }
            try {
                packetBuilder.setSizeLimit(defaultNetwork.maxDataSize(), false);
                packetBuilder.setVersion(defaultNetwork.getRemoteVersions());
                defaultNetwork.sendMessage(packetBuilder, target);
            }
            catch (IOException exception) {
                CommonData.LOGGER.error("Error while sending packet!", (Throwable)exception);
            }
        }
    }

    static void receiveMessage(ByteBuffer buffer, UUID player, INetworkInstance networkInstance) {
        try {
            NetData data = new EmotePacket.Builder().setThreshold(((Float)PlatformTools.getConfig().validThreshold.get()).floatValue()).build().read(buffer);
            if (!networkInstance.trustReceivedPlayer()) {
                data.player = null;
            }
            if (player != null) {
                data.player = player;
            }
            if (data.player == null && data.purpose.playerBound) {
                throw new IOException("Didn't received any player information");
            }
            try {
                ClientEmotePlay.executeMessage(data, networkInstance);
            }
            catch (Exception e) {
                CommonData.LOGGER.error("Critical error has occurred while receiving emote!", (Throwable)e);
            }
        }
        catch (IOException e) {
            CommonData.LOGGER.warn("Error while receiving packet!", (Throwable)e);
        }
    }

    @Override
    protected void dispatchReceive(ByteBuffer buffer, UUID player, INetworkInstance networkInstance) {
        ClientPacketManager.receiveMessage(buffer, player, networkInstance);
    }

    public static boolean isRemoteAvailable() {
        return defaultNetwork.isActive();
    }

    public static boolean isRemoteTracking() {
        return ClientPacketManager.isRemoteAvailable() && defaultNetwork.isServerTrackingPlayState();
    }

    public static boolean isAvailableProxy() {
        for (INetworkInstance instance : networkInstances) {
            if (!instance.isActive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onDisconnectFromServer(INetworkInstance networkInstance) {
        if (networkInstance == null) {
            throw new NullPointerException("network instance must be non-null");
        }
        EmoteHolder.clearEmotes(networkInstance);
    }
}

