/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.server.services;

import io.github.kosmx.emotes.api.services.IEmotecraftService;
import io.github.kosmx.emotes.common.tools.ServiceLoaderUtil;
import io.github.kosmx.emotes.server.config.Serializer;
import io.github.kosmx.emotes.server.services.impl.InstanceServiceImpl;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public interface InstanceService
extends IEmotecraftService {
    public static final InstanceService INSTANCE = ServiceLoaderUtil.loadService(InstanceService.class, InstanceServiceImpl::new);

    public Path getGameDirectory();

    default public Path getExternalEmoteDir() {
        return this.getGameDirectory().resolve(Serializer.getConfig().emotesDir.get());
    }

    default public Path getConfigPath() {
        String directoryName = "config";
        try {
            directoryName = System.getProperty("emotecraftConfigDir", "config");
            if (directoryName.equals("pluginDefault")) {
                directoryName = "plugins/emotecraft";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!Files.exists(this.getGameDirectory().resolve(directoryName), new LinkOption[0])) {
            try {
                Files.createDirectories(this.getGameDirectory().resolve(directoryName), new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.getGameDirectory().resolve(directoryName).resolve("emotecraft.json");
    }
}

