/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camerautils.config;

import de.maxhenkel.camerautils.configbuilder.ConfigBuilder;
import de.maxhenkel.camerautils.configbuilder.entry.ConfigEntry;

public class ClientConfig {
    public static final double MAX_ZOOM = 0.1;
    public static final double MIN_ZOOM = 1.5;
    public final ConfigEntry<Double> smoothness;
    public final ConfigEntry<Double> minSmoothValue;
    public final ConfigEntry<Double> maxSmoothValue;
    public final ConfigEntry<Double> cinematicCameraModifier;
    public final ConfigEntry<Double> zoom;
    public final ConfigEntry<Double> zoomSensitivity;
    public final ConfigEntry<Double> thirdPersonOffset;
    public final ConfigEntry<Double> thirdPersonOffsetSensitivity;
    public final ConfigEntry<Double> thirdPersonOffsetX1;
    public final ConfigEntry<Double> thirdPersonOffsetY1;
    public final ConfigEntry<Double> thirdPersonOffsetZ1;
    public final ConfigEntry<Double> thirdPersonRotationX1;
    public final ConfigEntry<Boolean> thirdPersonInverted1;
    public final ConfigEntry<Boolean> thirdPersonHideGui1;
    public final ConfigEntry<Double> thirdPersonOffsetX2;
    public final ConfigEntry<Double> thirdPersonOffsetY2;
    public final ConfigEntry<Double> thirdPersonOffsetZ2;
    public final ConfigEntry<Double> thirdPersonRotationX2;
    public final ConfigEntry<Boolean> thirdPersonInverted2;
    public final ConfigEntry<Boolean> thirdPersonHideGui2;
    public final ConfigEntry<ModifierKey> modifierKey;
    public final ConfigEntry<Double> guiOpacity;
    public final ConfigEntry<Double> zoomAnimationFrom;
    public final ConfigEntry<Double> zoomAnimationTo;
    public final ConfigEntry<Integer> zoomAnimationDuration;
    public static int thirdPersonCam = -1;
    public static boolean detached;
    public static float xRot;
    public static float yRot;
    public static double x;
    public static double y;
    public static double z;

    public ClientConfig(ConfigBuilder builder) {
        this.smoothness = builder.doubleEntry("smoothness", (Double)0.0, 0.0, 1.0, new String[0]);
        this.minSmoothValue = builder.doubleEntry("min_smoothness", (Double)40.0, 1.0, 1000.0, new String[0]);
        this.maxSmoothValue = builder.doubleEntry("max_smoothness", (Double)100.0, 1.0, 1000.0, new String[0]);
        this.cinematicCameraModifier = builder.doubleEntry("cinematic_camera_modifier", (Double)1.0, 0.0, 1.0, new String[0]);
        this.zoom = builder.doubleEntry("zoom", (Double)0.1, 0.0, 2.0, new String[0]);
        this.zoomSensitivity = builder.doubleEntry("zoom_sensitivity", (Double)0.01, 0.001, 1.0, new String[0]);
        this.thirdPersonOffset = builder.doubleEntry("third_person_offset", (Double)0.0, -32.0, 32.0, new String[0]);
        this.thirdPersonOffsetSensitivity = builder.doubleEntry("third_person_offset_sensitivity", (Double)0.1, 0.001, 1.0, new String[0]);
        this.thirdPersonOffsetX1 = builder.doubleEntry("third_person_cam_1_offset_x", (Double)-4.0, -100.0, 100.0, new String[0]);
        this.thirdPersonOffsetY1 = builder.doubleEntry("third_person_cam_1_offset_y", (Double)0.0, -100.0, 100.0, new String[0]);
        this.thirdPersonOffsetZ1 = builder.doubleEntry("third_person_cam_1_offset_z", (Double)0.0, -100.0, 100.0, new String[0]);
        this.thirdPersonInverted1 = builder.booleanEntry("third_person_cam_1_inverted", false, new String[0]);
        this.thirdPersonHideGui1 = builder.booleanEntry("third_person_cam_1_hide_gui", false, new String[0]);
        this.thirdPersonRotationX1 = builder.doubleEntry("third_person_cam_1_rotation_x", (Double)0.0, -90.0, 90.0, new String[0]);
        this.thirdPersonOffsetX2 = builder.doubleEntry("third_person_cam_2_offset_x", (Double)-4.0, -100.0, 100.0, new String[0]);
        this.thirdPersonOffsetY2 = builder.doubleEntry("third_person_cam_2_offset_y", (Double)0.0, -100.0, 100.0, new String[0]);
        this.thirdPersonOffsetZ2 = builder.doubleEntry("third_person_cam_2_offset_z", (Double)0.0, -100.0, 100.0, new String[0]);
        this.thirdPersonInverted2 = builder.booleanEntry("third_person_cam_2_inverted", false, new String[0]);
        this.thirdPersonHideGui2 = builder.booleanEntry("third_person_cam_2_hide_gui", false, new String[0]);
        this.thirdPersonRotationX2 = builder.doubleEntry("third_person_cam_2_rotation_x", (Double)0.0, -90.0, 90.0, new String[0]);
        this.modifierKey = builder.enumEntry("modifier_key", ModifierKey.RIGHT_ALT, new String[0]);
        this.guiOpacity = builder.doubleEntry("gui_opacity", (Double)1.0, 0.0, 1.0, new String[0]);
        this.zoomAnimationFrom = builder.doubleEntry("zoom_animation_from", (Double)1.0, 0.01, 2.0, new String[0]);
        this.zoomAnimationTo = builder.doubleEntry("zoom_animation_to", (Double)0.1, 0.01, 2.0, new String[0]);
        this.zoomAnimationDuration = builder.integerEntry("zoom_animation_duration", (Integer)200, 1, Integer.MAX_VALUE, new String[0]);
    }

    public static enum ModifierKey {
        CTRL,
        RIGHT_ALT;

    }
}

