/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.render;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.util.List;
import mod.crend.dynamiccrosshair.DynamicCrosshairMod;
import mod.crend.dynamiccrosshair.compat.AutoHudCompat;
import mod.crend.dynamiccrosshair.component.CrosshairComponent;
import mod.crend.dynamiccrosshair.component.CrosshairHandler;
import mod.crend.dynamiccrosshair.style.CrosshairStyle;
import mod.crend.dynamiccrosshair.style.CrosshairStyleManager;
import mod.crend.dynamiccrosshair.style.CrosshairStyledPart;
import mod.crend.dynamiccrosshairapi.VersionUtils;
import net.minecraft.class_1041;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class CrosshairRenderer {
    public static boolean autoHudCompat = false;

    private static void setColor(int argb, boolean enableBlend) {
    }

    public static void preRender() {
        CrosshairStyle defaultStyle = CrosshairHandler.getDefaultCrosshair();
        CrosshairRenderer.setColor(defaultStyle.color(), defaultStyle.enableBlend());
    }

    public static void fixCenteredCrosshairPre(class_332 context, int x, int y) {
        class_1041 window = class_310.method_1551().method_22683();
        double scale = window.method_4495();
        double i = (double)window.method_4489() / scale;
        double j = (double)window.method_4506() / scale;
        double dx = (i - 15.0) / 2.0 - (double)x;
        double dy = (j - 15.0) / 2.0 - (double)y;
        context.method_51448().pushMatrix();
        context.method_51448().setTranslation((float)dx, (float)dy);
    }

    public static void fixCenteredCrosshairPost(class_332 context) {
        context.method_51448().popMatrix();
    }

    public static void renderCrosshair(class_332 context, class_2960 style, RenderPipeline renderLayer, int x, int y, int color) {
        CrosshairStyleManager.INSTANCE.get(style).draw(context, renderLayer, x, y, color);
    }

    public static void renderCrosshair(class_332 context, CrosshairStyle style, int x, int y) {
        CrosshairRenderer.setColor(style.color(), style.enableBlend());
        CrosshairRenderer.renderCrosshair(context, style.identifier(), style.enableBlend() ? VersionUtils.getCrosshair() : VersionUtils.getGuiTextured(), x, y, style.color());
    }

    private static void preRenderHalf() {
    }

    private static void postRenderHalf(class_332 context, boolean blend) {
    }

    private static void renderStyles(class_332 context, int x, int y, List<CrosshairStyledPart> styles) {
        for (CrosshairStyledPart part : styles) {
            if (autoHudCompat) {
                AutoHudCompat.renderCrosshair(context, part.part(), part.style(), x, y);
                continue;
            }
            CrosshairRenderer.renderCrosshair(context, part.style(), x, y);
        }
    }

    public static void render(class_332 context, int x, int y) {
        CrosshairComponent crosshair = CrosshairHandler.getActiveCrosshair();
        CrosshairRenderer.preRenderHalf();
        CrosshairRenderer.renderStyles(context, x, y, crosshair.getStylesWithBlend());
        CrosshairRenderer.postRenderHalf(context, true);
        CrosshairRenderer.preRenderHalf();
        CrosshairRenderer.renderStyles(context, x, y, crosshair.getStylesWithoutBlend());
        CrosshairRenderer.postRenderHalf(context, false);
    }

    public static void postRender() {
    }

    public static void wrapRender(class_332 context, int x, int y, class_2960 oTexture, int oWidth, int oHeight, Runnable originalRenderCall) {
        if (!CrosshairHandler.forceShowCrosshair && !CrosshairHandler.shouldShowCrosshair()) {
            return;
        }
        if (DynamicCrosshairMod.config.isFixCenteredCrosshair()) {
            CrosshairRenderer.fixCenteredCrosshairPre(context, x, y);
        }
        if (DynamicCrosshairMod.config.isDynamicCrosshairStyle()) {
            CrosshairRenderer.render(context, x, y);
        } else if (CrosshairHandler.getDefaultCrosshair().color() != -1) {
            context.method_52707(CrosshairHandler.getDefaultCrosshair().enableBlend() ? VersionUtils.getCrosshair() : VersionUtils.getGuiTextured(), oTexture, x, y, oWidth, oHeight, CrosshairHandler.getDefaultCrosshair().color());
        } else if (!CrosshairHandler.getDefaultCrosshair().enableBlend()) {
            context.method_52706(VersionUtils.getGuiTextured(), oTexture, x, y, oWidth, oHeight);
        } else {
            originalRenderCall.run();
        }
        if (DynamicCrosshairMod.config.isFixCenteredCrosshair()) {
            CrosshairRenderer.fixCenteredCrosshairPost(context);
        }
        CrosshairRenderer.postRender();
    }
}

