/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.reeses_sodium_options.client.gui.frame;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.AbstractFrame;
import net.caffeinemc.mods.sodium.client.gui.widgets.AbstractWidget;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_332;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public class BasicFrame
extends AbstractFrame {
    protected List<Function<Dim2i, AbstractWidget>> functions;

    public BasicFrame(Dim2i dim, boolean renderOutline, List<Function<Dim2i, AbstractWidget>> functions) {
        super(dim, renderOutline);
        this.functions = functions;
        this.buildFrame();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void buildFrame() {
        this.children.clear();
        this.controlElements.clear();
        this.functions.forEach(function -> this.children.add((AbstractWidget)function.apply(this.dim)));
        super.buildFrame();
    }

    @Override
    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
    }

    public static class Builder {
        private final List<Function<Dim2i, AbstractWidget>> functions = new ArrayList<Function<Dim2i, AbstractWidget>>();
        private Dim2i dim;
        private boolean renderOutline;

        public Builder withDimension(Dim2i dim) {
            this.dim = dim;
            return this;
        }

        public Builder withRenderOutline(boolean renderOutline) {
            this.renderOutline = renderOutline;
            return this;
        }

        public Builder addChild(Function<Dim2i, AbstractWidget> function) {
            this.functions.add(function);
            return this;
        }

        public BasicFrame build() {
            Validate.notNull((Object)this.dim, (String)"Dimension must be specified", (Object[])new Object[0]);
            return new BasicFrame(this.dim, this.renderOutline, this.functions);
        }
    }
}

